from django.db import models


class Setting(models.Model):
    option_name = models.CharField(max_length=40)
    option_value = models.CharField(max_length=512, null=True, blank=True)

    def __str__(self):
        return self.option_name

    def __repr__(self):
        return f"<Setting ({self.option_name}={self.option_value})>"
